#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../video.h"

#define _TRAME_

#define FOND_Z 1.f
#ifdef _TRAME_
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,200.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,200.f/FOND_Z,1.f/FOND_Z}};
#else
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  255,128,128,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   128,255,128,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,100.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   64,64,192,   0,128.f,1.f/FOND_Z,{0,100.f/FOND_Z,1.f/FOND_Z}};
#endif

static struct jpeg_decompress_struct cinfo;
static struct jpeg_error_mgr jerr;
static FILE *file;
static BYTE *buffer[400];
static BYTE pixelbuf[256*400];

void LInit_Video()
{
	//PrepareVideo();
	DWORD Cpt1;

	buffer[0] = &pixelbuf[0];
	for(Cpt1=0;Cpt1<400;Cpt1++)
		buffer[Cpt1] = buffer[0] + Cpt1 * 256;
}

void QInit_Video()
{
	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_LOCAL,
		 GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	//grConstantColorValue(0x80ff80);
	grConstantColorValue(0x00ff00);
	//grConstantColorValue(0xff0000);
	//grConstantColorValue(0xff8080);

	g_TextureBuff.info.format = GR_TEXFMT_INTENSITY_8;
	SelectTexture(g_TextureBuff);

	jpeg_create_decompress(&cinfo);
	cinfo.err = jpeg_std_error(&jerr);

	file = fopen("flo.jpg", "rb");

	jpeg_stdio_src(&cinfo, file);
	jpeg_read_header(&cinfo, TRUE);
	jpeg_start_decompress(&cinfo);

	memset(g_FrameBuf3d, 0, 65536);
}

void Effect_Video()
{
	static DWORD Old = 0;
	int Count;
	static int OldCount = -1;
	static BYTE Trame[256*100];
	int Dummy;
	DWORD Cpt1;

	static DWORD NextHeight = 0;
	DWORD TmpHeight;

	Count = (g_demostate.TickInEffect)*568.f/56.f/1000.f;

	if (
	    
		(OldCount != Count)
		&&
		(Count<568)
		)
	{
        OldCount = Count;

		NextHeight += 100;

		while (cinfo.output_scanline < NextHeight)
		{
			jpeg_read_scanlines(&cinfo, 
			buffer+cinfo.output_scanline-NextHeight+100
			//, 100);
			,1);
		}

#ifndef _TRAME_
		memcpy(g_FrameBuf3d, buffer[0], 256*100);
#else
		for(Cpt1=0;Cpt1<100;Cpt1++)
		{
			memcpy(((BYTE*)g_FrameBuf3d)+Cpt1*256*2, buffer[0]+Cpt1*256, 256);
		}
#endif
		grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);
	}
	else
	{
		if (g_demostate.TickInEffect>56000)
		{
			Dummy = 2048 - (g_demostate.TickInEffect-56000);
			Dummy /= 8;
			if (Dummy<0)
				Dummy = 0;
			else
			{
				if (Dummy>255)
					Dummy = 255;
				Dummy = Dummy << 8;
			}
			grConstantColorValue(Dummy);
		}
	}

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);
}

void ByeBye_Video()
{
	jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);

	fclose(file);

	if (g_demostate.NoSoundMode == false)
	{
		ModuleShutDown();
		InitModule(g_szModulename);
		g_demostate.playHandle = MIDASplayModule(g_demostate.module, FALSE);
	}
}
	
